#ifndef __CKeyboardEvent__
#define __CKeyboardEvent__

#include <Basics/CCountedObject.hpp>
using Exponent::Basics::CCountedObject;

//	===========================================================================

namespace Exponent
{
	namespace GUI
	{
		namespace Events
		{
			/**
			 * @class CKeyboardEvent CKeyboardEvent.hpp
			 * @brief Allows for responding to keyboard actions
			 *
			 * @date 21/08/2004
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: CKeyboardEvent.hpp,v 1.3 2007/02/08 21:07:54 paul Exp $
			 */
			class CKeyboardEvent : public CCountedObject
			{
				/** @cond */
				EXPONENT_CLASS_DECLARATION;
				/** @endcond */

//	===========================================================================

			public:

//	===========================================================================

				/**
				 * Construction
				 */
				CKeyboardEvent();

				/**
				 * Destruction
				 */
				virtual ~CKeyboardEvent();

//	===========================================================================

				/**
				 * SEt the key code
				 * @param key The key that was pressed
				 */
				void setKey(const char key);

				/**
				 * Get the virtual key code
				 * @retval char The key depressed 
				 */
				char getKey() const;

				/**
				 * Set the modifiers
				 * @param shift True if shift is down, false otherwise
				 * @param alt True if alt is down, false otherwise
				 * @param ctrl True if ctrl is down, false otherwise
				 */
				void setModifiers(const bool shift, const bool alt, const bool ctrl);

				/**
				 * Is ctrl down
				 * @retval bool True if ctrl is down, false otherwise
				 */
				bool isCtrlDown() const;

				/**
				 * Is shift down
				 * @retval bool True if shift is down, false otherwise
				 */
				bool isShiftDown() const;

				/**
				 * Is the alt key down
				 * @retval bool True if alt is down, false otherwise
				 */
				bool isAltDown() const;

//	===========================================================================

			protected:

//	===========================================================================

				char m_key;								/**< The character that was pressed */
				bool m_shiftIsDown;						/**< Is shift key depressed */
				bool m_altIsDown;						/**< Is the alt key depressed */
				bool m_ctrlIsDown;						/**< Is the ctrl key depressed */


			};
		}
	}
}
#endif	// End of CKeyboardEvent.hpp